Relayer API Solana utils (examples)

Build authority-signed, base64-encoded transactions for the relayer without sending HTTP requests. Targets Token-2022 RWA flows and leaves the payer signature empty for the relayer to sign.

## What’s inside

- `scripts/mintSecuritiesBase64.ts` — creates the destination ATA (if missing), derives the SecurityAssociatedAccount PDA, builds `mintSecurities`, and prints `txBase64`.
- `scripts/transferWithHookBase64.ts` — validates balances, optionally creates the recipient ATA, adds a higher CU limit, builds transfer-with-hook, and prints `txBase64`.
- `scripts/setAddressPermissionBase64.ts` — ensures the wallet ATA exists, derives/initializes holder + holder-group PDAs when needed, updates the wallet’s transfer group/frozen state, and prints `txBase64`.

## Setup

```bash
pnpm install  # or npm install / yarn
```

## Run the scripts

Environment variables shared across scripts:

- `RPC_URL` (optional) — defaults to devnet.
- `PAYER_ADDRESS` — relayer fee payer public key. `RELAYER_FEE_PAYER` overrides it if set.
- `AUTHORITY_PRIVATE_KEY_B64` — base64-encoded 64-byte ed25519 secret key. Required signer.

### Mint securities

```bash
RPC_URL=... \
TOKEN_MINT=... \
DESTINATION_WALLET=... \
PAYER_ADDRESS=... \
AUTHORITY_PRIVATE_KEY_B64=... \
AMOUNT_RAW=1000000 \
pnpm mint:base64
```

### Transfer with hook

```bash
RPC_URL=... \
TOKEN_MINT=... \
TO_WALLET=... \
PAYER_ADDRESS=... \
AUTHORITY_PRIVATE_KEY_B64=... \
AMOUNT_RAW=1000 \
pnpm transfer:base64
```

### Set address permission (transfer restrictions)

```bash
RPC_URL=... \
TOKEN_MINT=... \
WALLET_ADDRESS=... \
GROUP_ID=1 \
FROZEN=false \
PAYER_ADDRESS=... \
AUTHORITY_PRIVATE_KEY_B64=... \
pnpm set-permission:base64
```

- Initializes holder/holder-group PDAs if missing; fails if the target group does not exist.
- Updates the wallet’s transfer group and frozen state when already registered; errors if no change is needed.

## Notes

- Outputs are base64 transactions signed by the authority; pass them to the relayer along with your usual request headers.
- Uses Token-2022 program addresses baked into `scripts/helpers/constants.ts`.
- Ensure keys and IDs match the cluster you target; replace any placeholder keys before running.
